% Section 5.6.1 Case 1: State Feedback
% 29/02/2020, Jianglin Lan
close all
clear
clc

% Set up Yalmip & Mosek, this may differ on different computer
% Find installation details in links: 
% https://yalmip.github.io/tutorial/installation/
% https://docs.mosek.com/9.1/toolbox/install-interface.html
addpath(genpath('C:\YALMIP-master'))
addpath('C:\Program Files\Mosek\8\toolbox\r2014a')

% System 
R0 = 1.2; L0 = 0.05; Kv = 0.6; Km = 0.6; J0 = 0.1352; B0 = 0.3;
d_Km = 0.01; d_Kv = 0.01;

A = [-R0/L0  -Kv/L0; Km/J0  -B0/J0]; 
B = [1/L0; 0]; 
Fa = [1/(10*L0); 0]; 
D = [0;1]; 
C = eye(2); 
Fs = [-1;2];

% Uncertainty
Delta_A = [0 d_Kv;d_Km  0];

% Design FE observer and FTC controller
alpha1 = d_Km; beta1 = d_Kv;
Mc = eye(2);
Fc = [d_Kv/alpha1 0; 0 d_Km/beta1];
Nc = [0 alpha1; beta1 0];
L = [0 0 1 0;0 0 0 1];

[Kx,M,H,R,G,betas,gammas] = Observer_controller_design(A,B,Fa,D,C,Fs,Mc,Nc,L)

% Define global variables to store data
global Int_ffa Int_ffs Int_yy1 Int_yy2 Int_ts Int_count Int_tmp Int_hatfa Int_hatfs Int_u
global Intn_ts Intn_count Intn_tmp Intn_hatfa Intn_hatfs Intn_yy1 Intn_yy2

Int_hatfa = []; Int_hatfs = []; Int_ffa = []; Int_ffs = []; Int_yy1 = []; Int_yy2 = []; 
Int_ts = []; Int_count = 0; Int_tmp = 0; Int_u= [];
Intn_ts = []; Intn_tmp = 0; Intn_count = 0; Intn_hatfa = []; Intn_hatfs = []; Intn_yy1 = []; Intn_yy2 = [];

% Initial conditon
hat_eta0 = 0;
xi0 = [0;0];
x0 = [0.5;0.5];
xx0 = [hat_eta0', xi0',x0'];

% Simulation time span
t0 = 0;
tf = 25;
tspan = [t0 tf];

% Solve differential equation
[Ints_tt,Int_ys] = ode45(@(t,xx) Nominal_control_closed_sys_performance(t,xx,A,B,Fa,D,C,Fs,Delta_A,Kx,M,H,R,G), tspan,xx0);
Ints_x1 = Int_ys(:,4);
Ints_x2 = Int_ys(:,5);

[Int_tt,Int_yy] = ode45(@(t,xx) FTC_closed_sys_performance(t,xx,A,B,Fa,D,C,Fs,Delta_A,Kx,M,H,R,G), tspan,xx0);
Int_x1 = Int_yy(:,4);
Int_x2 = Int_yy(:,5);

% Draw figure
run('Draw_figures.m');